//
// Fragment shader for Picasso effect
//
// Author: Shirley Carter
//

uniform sampler2DRect texUnit;
uniform  vec4 modulateColor;

uniform vec4 textureRect;

uniform float time;
uniform vec2 drawingOffset;
uniform vec2 drawingScale;
uniform vec4 drawingBoundsRect;

varying vec2 gUV;

//saturation variables
const vec3 lumCoeff = vec3 (0.2125, 0.7154, 0.0721);
const float kSmallVal = 0.001; 
//darkness
vec3 AvgLuminance = vec3(0.5, 0.5, 0.5);//assumption
float darknessFactor;

vec3 RGBtoHSV( float r, float g, float b );
vec3 HSVtoRGB( float h, float s, float v );

bool InBound(float x, float a, float b)
{
    return (x > a && x<=b);
}
void main(void)
{
    if ( gUV.x< textureRect.x || gUV.x> textureRect.x+textureRect.z || gUV.y < textureRect.y || gUV.y > textureRect.y+textureRect.w )
        gl_FragColor = vec4(0.0,0.0,0.0,0.0);
    else {
        float tt = float(time); //convert to seconds
        
        // This pixel location
        vec3 pCoord = gl_FragCoord.xyz;
        // Transform back to render traget coord space
        pCoord /= vec3(drawingScale, 1);
        pCoord += vec3(drawingOffset, 0);
        
        vec2 drawingOrigin = drawingBoundsRect.xy;
        float drawingWidth = drawingBoundsRect.z;
        float drawingHeight = drawingBoundsRect.w;
        
        vec4 part = texture2DRect( texUnit, gUV );
        
        if ( part.r>kSmallVal || part.g>kSmallVal ||part.b>kSmallVal || part.a>kSmallVal ) {
            
            
            float texWidth = textureRect.z;
            float texHeight = textureRect.w;
            
            float textureWidth = texWidth;
            float textureHeight = texHeight;
            
            
            float ratio1 = time;//time;//max(0.65,sin(tt)) ;//max(0.65, sin(tt));//0.79;//*;
            float ratio2 = 1.18-ratio1;// 0.39;
            float ratio3 = 1.48-ratio1;//0.69;
            float ratio4 = 0.99 - ratio1;//0.2;
            float ratio5 = 1.0-ratio1; //0.21;
            float ratio6 = 1.2-ratio1;//0.41;
            float ratio7 = 1.22-ratio1;//0.43;
            float ratio8 = 1.37-ratio1;//0.58;
            float ratio9 = 1.46-ratio1;//0.67;
            float ratio10 =1.3-ratio1;// 0.51;
            float ratio11 =1.45-ratio1;// 0.66;
            float ratio12 =1.04-ratio1;// 0.25;
            float ratio13 =1.08-ratio1;// 0.29;
            
            float left = drawingOrigin.x;
            float right = drawingOrigin.x+drawingWidth;
            float top = drawingOrigin.y;
            float bottom = drawingOrigin.y+drawingHeight;
            float hRatio = textureHeight/drawingHeight;
            float wRatio = textureWidth/drawingWidth;
            
            if( InBound(pCoord.x, left,  left+ratio1*drawingWidth) && InBound( pCoord.y,  top+ratio1*drawingHeight , bottom))
            {
                float x = textureRect.x+texWidth-gUV.x;
                float y = textureRect.y+(texHeight-(gUV.y-textureRect.y)+texHeight/4.0);
                x = InBound(x, textureRect.x, textureRect.x+texWidth)?x:gUV.x;
                y = InBound(y, textureRect.y, textureRect.y+texHeight)?y:texHeight-gUV.y;
                
                part = texture2DRect( texUnit, vec2(x, y) );
                int div = 120;
                float mul = float(div);
                part.r = float( int( part.r*360.0 ) / div )*mul / 360.0*1.2+ float(div)/360.0 ;
                part.g = float( int( part.g*360.0 ) / div )*mul / 360.0*.2+ float(div)/360.0 ;
                part.b = float( int( part.b*360.0 ) / div )*mul / 360.0+ float(div)/360.0 ;
            }
            else if( InBound(pCoord.x, left+ratio1*drawingWidth, right) && InBound( pCoord.y,top+ratio2*drawingHeight,bottom))
            {
                float x = gUV.x-texWidth/4.0;
                float y = textureRect.y+texHeight-gUV.y+texHeight/3.0 ;
                
                x = InBound(x, textureRect.x, textureRect.x+texWidth)?x:textureRect.x+texWidth-gUV.x;
                y = InBound(y, textureRect.y, textureRect.y+texHeight)?y:textureRect.y+texHeight-gUV.y;
                
                vec4 sum = texture2DRect( texUnit, vec2( x, y) );
                //vec4 sum = texture2DRect( texUnit, gUV );
                //Posterize
                int div = 50;
                float mul = float(div);
                sum.r = float( int( sum.r*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
                sum.g = float( int( sum.g*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
                sum.b = float( int( sum.b*360.0 ) / div )*mul / 360.0*1.5; //+ float(div)/360.0 ;
                
                part = sum;
            }
            else if( InBound(pCoord.x,left+ratio3*drawingWidth,right) && InBound( pCoord.y,top, top+ratio2*drawingHeight))
            {
                float x = 2.0 * ((gUV.x-textureRect.x)*1.4-2.0*textureWidth/3.0) / textureWidth - 1.0 ;//1.5
                float y = 2.0 * (textureHeight-(gUV.y-textureRect.y)*1.1-textureHeight/4.0) / textureHeight - 1.0 ;//1.1
              
                //warped in the middle
                //        x = sign( x ) * x * x;
                //        y = sign( y ) * y * y ;
                
                float i = (x + 1.0 )*textureWidth*.5+textureRect.x;
                float j = (y + 1.0 )*textureHeight*.5+textureRect.y;
                i  = InBound(i, textureRect.x, textureRect.x+texWidth)?i:gUV.x;
                j = InBound(j, textureRect.y, textureRect.y+texHeight)?j:gUV.y;
                
                part = texture2DRect( texUnit, vec2(i,j));// );//vec2( TexCoord.x*1.5-2.0*texWidth/3.0, texHeight-TexCoord.y*1.1-texHeight/4.0) );
                
                
                int div = 60;//Users/shirleycarter66/Downloads/Project1/picasso.frag
                float mul = float(div);
                part.r = float( int( part.r*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
                part.g = float( int( part.g*360.0 ) / div )*mul / 360.0*1.5; //+ float(div)/360.0 ;
                part.b = float( int( part.b*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
            }
            else if( InBound(pCoord.x,left+ratio4*drawingWidth,left+ratio3*drawingWidth) && InBound( pCoord.y,top, top+ratio5*drawingHeight))
            {
                float x = 2.0 * (textureWidth/3.0+gUV.x*.6-textureRect.x*.6) / textureWidth - 1.0 ;
                float y = 2.0 * (gUV.y*.6-textureRect.y*.6 + textureHeight/3.0) / textureHeight - 1.0 ;
                
                //        x = 2.0 * asin(x) / 3.1415926;
                //        y = 2.0 * asin(y) / 3.1415926;
                
                float i = (x + 1.0 )*textureWidth*.5+textureRect.x;
                float j = (y + 1.0 )*textureHeight*.5+textureRect.y;
                i  = InBound(i, textureRect.x, textureRect.x+texWidth)?i:gUV.x;
                j = InBound(j, textureRect.y, textureRect.y+texHeight)?j:gUV.y;
                
                part = texture2DRect( texUnit, vec2(i,j) );//vec2( TexCoord.x*1.5-2.0*texWidth/3.0, texHeight-TexCoord.y*1.1-texHeight/4.0) );
                
                
                int div = 40;
                float mul = float(div);
                part.r = float( int( part.r*360.0 ) / div )*mul / 360.0*1.5; //+ float(div)/360.0 ;
                part.g = float( int( part.g*360.0 ) / div )*mul / 360.0*.7; //+ float(div)/360.0 ;
                part.b = float( int( part.b*360.0 ) / div )*mul / 360.0*1.5; //+ float(div)/360.0 ;
            }
            
            else if( InBound(pCoord.x, left, left+ratio4*drawingWidth) && InBound( pCoord.y,top, top+ratio6*drawingHeight))
            {
                
                float x = 2.0 * (textureWidth/2.0-gUV.x*.8+textureRect.x*0.8) / textureWidth - 1.0 ;
                float y = 2.0 * (gUV.y*.8-textureRect.y*0.8+ textureHeight/4.0) / textureHeight - 1.0 ;
                
                //		float r = sqrt(x*x + y*y);
                //        float phi = atan(y,x);//equivalent to atan2
                //
                //        float t = 3.1415/4.0;//mod( float( timer ), 30000.0 ) / 1000.0; //0 - 30 seconds
                //        float fac = abs( sin( t ) )*2.0 + .125;//+1.5;/// 2.0 + 1.5;
                //        r = pow( r, fac );//fac );//magnifier
                //
                //		x = r * cos( phi );
                //        y = r * sin( phi );
                
                float i = (x + 1.0 )*textureWidth*.5+textureRect.x;
                float j = (y + 1.0 )*textureHeight*.5+textureRect.y;
            
                i  = InBound(i, textureRect.x, textureRect.x+texWidth)?i:gUV.x;
                j = InBound(j, textureRect.y, textureRect.y+texHeight)?j:gUV.y;
                
                part = texture2DRect( texUnit, vec2(i,j) ); //texture2DRect( whichTexture, vec2( texWidth/2.0-TexCoord.x*.8, TexCoord.y*.8+ texHeight/4.0) );
                
                int div = 60;
                float mul = float(div);
                part.r = float( int( part.r*360.0 ) / div )*mul / 360.0*1.4; //+ float(div)/360.0 ;
                part.g = float( int( part.g*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
                part.b = float( int( part.b*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
                
            }
            else if( InBound(pCoord.x,left+ratio4*drawingWidth,left+ratio7*drawingWidth) && InBound( pCoord.y,top+ratio5*drawingHeight,top+ratio6*drawingHeight))
            {
                
                float x = 2.0 * (gUV.x*1.4-textureRect.x*1.4) / textureWidth - 1.0 ;
                float y = 2.0 * (gUV.y*1.4-textureRect.y*1.4) / textureHeight - 1.0 ;
                
                //		float r = sqrt(x*x + y*y);
                //        float phi = atan(y,x);//equivalent to atan2
                //
                //        float t = 3.1415/4.0;//mod( float( timer ), 30000.0 ) / 1000.0; //0 - 30 seconds
                //        float fac = abs( sin( t ) )*2.0 + .125;//+1.5;/// 2.0 + 1.5;
                //        r = pow( r, fac );//fac );//magnifier
                //
                //		x = r * cos( phi );
                //        y = r * sin( phi );
                
                float i = (x + 1.0 )*textureWidth*.5+textureRect.x;
                float j = (y + 1.0 )*textureHeight*.5+textureRect.y;
                i  = InBound(i, textureRect.x, textureRect.x+texWidth)?i:gUV.x;
                j = InBound(j, textureRect.y, textureRect.y+texHeight)?j:gUV.y;
                part = texture2DRect( texUnit, vec2(i,j) ); //texture2DRect( whichTexture, vec2( texWidth/2.0-TexCoord.x*.8, TexCoord.y*.8+ texHeight/4.0) );
                
                int div = 80;
                float mul = float(div);
                part.r = float( int( part.r*360.0 ) / div )*mul / 360.0*1.6; //+ float(div)/360.0 ;
                part.g = float( int( part.g*360.0 ) / div )*mul / 360.0*.4; //+ float(div)/360.0 ;
                part.b = float( int( part.b*360.0 ) / div )*mul / 360.0*.5; //+ float(div)/360.0 ;
                
            }
            else if( InBound(pCoord.x,left+ratio7*drawingWidth, left+ratio8*drawingWidth) && InBound( pCoord.y,top+ratio5*drawingHeight, top+ratio6*drawingHeight))
            {
                
                float x = 2.0 * 0.75*(gUV.x*1.0-textureRect.x) / textureWidth - 1.0 ;
                float y = 2.0 * 0.75*(gUV.y*1.0-textureRect.y) / textureHeight - 1.0 ;
                
                //		float r = sqrt(x*x + y*y);
                //        float phi = atan(y,x);//equivalent to atan2
                //
                //        float t = 3.1415/4.0;//mod( float( timer ), 30000.0 ) / 1000.0; //0 - 30 seconds
                //        float fac = abs( sin( t ) )*2.0 + .125;//+1.5;/// 2.0 + 1.5;
                //        r = pow( r, fac );//fac );//magnifier
                //
                //		x = r * cos( phi );
                //        y = r * sin( phi );
                
                float i = (x + 1.0 )*textureWidth*.5+textureRect.x;
                float j = (y + 1.0 )*textureHeight*.5+textureRect.y;
                i  = InBound(i, textureRect.x, textureRect.x+texWidth)?i:gUV.x;
                j = InBound(j, textureRect.y , textureRect.y+texHeight)?j:gUV.y;
                part =  texture2DRect( texUnit, vec2(i,j) ); //texture2DRect( whichTexture, vec2( texWidth/2.0-TexCoord.x*.8, TexCoord.y*.8+ texHeight/4.0) );
                
                int div = 110;
                float mul = float(div);
                part.r = float( int( part.r*360.0 ) / div )*mul / 360.0*.9; //+ float(div)/360.0 ;
                part.g = float( int( part.g*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
                part.b = float( int( part.b*360.0 ) / div )*mul / 360.0*1.4; //+ float(div)/360.0 ;
                
            }
            else if( InBound(pCoord.x, left+ratio8*drawingWidth, left+ratio3*drawingWidth) && InBound( pCoord.y,top+ratio5*drawingHeight,top+ratio6*drawingHeight))
            {
                
                float x = 2.0 * (gUV.x-textureRect.x ) / textureWidth - 1.0 ;
                float y = 2.0 * (gUV.y-textureRect.y ) / textureHeight - 1.0 ;
                
                //		float r = sqrt(x*x + y*y);
                //        float phi = atan(y,x);//equivalent to atan2
                //
                //        float t = 3.1415/4.0;//mod( float( timer ), 30000.0 ) / 1000.0; //0 - 30 seconds
                //        float fac = abs( sin( t ) )*2.0 + .125;//+1.5;/// 2.0 + 1.5;
                //        r = pow( r, fac );//fac );//magnifier
                //
                //		x = r * cos( phi );
                //        y = r * sin( phi );
                
                float i = (x + 1.0 )*textureWidth*.5+textureRect.x;
                float j = (y + 1.0 )*textureHeight*.5+textureRect.y;
                i  = InBound(i, textureRect.x, textureRect.x+texWidth)?i:gUV.x;
                j = InBound(j, textureRect.y , textureRect.y+texHeight)?j:gUV.y;
                part =  texture2DRect( texUnit, vec2(i,j) ); //texture2DRect( whichTexture, vec2( texWidth/2.0-TexCoord.x*.8, TexCoord.y*.8+ texHeight/4.0) );
                
                int div = 65;
                float mul = float(div);
                part.r = float( int( part.r*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
                part.g = float( int( part.g*360.0 ) / div )*mul / 360.0*1.1; //+ float(div)/360.0 ;
                part.b = float( int( part.b*360.0 ) / div )*mul / 360.0*1.6; //+ float(div)/360.0 ;
                
            }
            else if( InBound(pCoord.x, left+ratio8*drawingWidth,left+ratio3*drawingWidth) && InBound( pCoord.y,top+ratio6*textureHeight, top+ratio9*drawingHeight))
            {
                
                float x = 2.0 *1.06*(gUV.x-textureRect.x) / textureWidth - 1.0 ;
                float y = 2.0 *1.06*(gUV.y-textureRect.y) / textureHeight - 1.0 ;
                
                //		float r = sqrt(x*x + y*y);
                //        float phi = atan(y,x);//equivalent to atan2
                //
                //        float t = 3.1415/4.0;//mod( float( timer ), 30000.0 ) / 1000.0; //0 - 30 seconds
                //        float fac = abs( sin( t ) )*2.0 + .125;//+1.5;/// 2.0 + 1.5;
                //        r = pow( r, fac );//fac );//magnifier
                //
                //		x = r * cos( phi );
                //        y = r * sin( phi );
                
                float i = (x + 1.0 )*textureWidth*.5+textureRect.x ;
                float j = (y + 1.0 )*textureHeight*.5+textureRect.y ;
                i  = InBound(i, textureRect.x, textureRect.x+texWidth)?i:gUV.x;
                j = InBound(j, textureRect.y , textureRect.y+texHeight)?j:gUV.y;
                part = texture2DRect( texUnit, vec2(i,j) ); //texture2DRect( whichTexture, vec2( texWidth/2.0-TexCoord.x*.8, TexCoord.y*.8+ texHeight/4.0) );
                
                int div = 50;
                float mul = float(div);
                part.r = float( int( part.r*360.0 ) / div )*mul / 360.0*.9; //+ float(div)/360.0 ;
                part.g = float( int( part.g*360.0 ) / div )*mul / 360.0*1.5; //+ float(div)/360.0 ;
                part.b = float( int( part.b*360.0 ) / div )*mul / 360.0*.9; //+ float(div)/360.0 ;
                
            }
            else if( InBound(pCoord.x, left+ratio10*drawingWidth, left+ratio8*drawingWidth) && InBound( pCoord.y,top+ratio6*drawingHeight, top+ratio1*drawingHeight))
            {
                
                float x = 2.0 * (gUV.x*1.01-textureRect.x*1.01) / textureWidth - 1.0 ;
                float y = 2.0 * (gUV.y*1.01-textureRect.y*1.01) / textureHeight - 1.0 ;
                
                //		float r = sqrt(x*x + y*y);
                //        float phi = atan(y,x);//equivalent to atan2
                //
                //        float t = 3.1415/4.0;//mod( float( timer ), 30000.0 ) / 1000.0; //0 - 30 seconds
                //        float fac = abs( sin( t ) )*2.0 + .125;//+1.5;/// 2.0 + 1.5;
                //        r = pow( r, fac );//fac );//magnifier
                //
                //		x = r * cos( phi );
                //        y = r * sin( phi );
                
                float i = (x + 1.0 )*textureWidth*.5+textureRect.x ;
                float j = (y + 1.0 )*textureHeight*.5+textureRect.y ;
                i  = InBound(i, textureRect.x , textureRect.x+texWidth)?i:gUV.x;
                j = InBound(j, textureRect.y , textureRect.y+texHeight)?j:gUV.y;
                part =  texture2DRect( texUnit, vec2(i,j) ); //texture2DRect( whichTexture, vec2( texWidth/2.0-TexCoord.x*.8, TexCoord.y*.8+ texHeight/4.0) );
                
                int div = 45;
                float mul = float(div);
                part.r = float( int( part.r*360.0 ) / div )*mul / 360.0*1.2; //+ float(div)/360.0 ;
                part.g = float( int( part.g*360.0 ) / div )*mul / 360.0*.9; //+ float(div)/360.0 ;
                part.b = float( int( part.b*360.0 ) / div )*mul / 360.0*1.1; //+ float(div)/360.0 ;
                
            }
            else if( InBound(pCoord.x, left+ratio5*drawingWidth,left+ratio10*drawingWidth) && InBound( pCoord.y,top+ratio11*drawingHeight, top+ratio1*drawingHeight))
            {
                
                float x = 2.0 * (gUV.x*1.03-textureRect.x*1.03) / textureWidth - 1.0 ;
                float y = 2.0 * (gUV.y*1.03)-textureRect.y*1.03 / textureHeight - 1.0 ;
                
                //		float r = sqrt(x*x + y*y);
                //        float phi = atan(y,x);//equivalent to atan2
                //
                //        float t = 3.1415/4.0;//mod( float( timer ), 30000.0 ) / 1000.0; //0 - 30 seconds
                //        float fac = abs( sin( t ) )*2.0 + .125;//+1.5;/// 2.0 + 1.5;
                //        r = pow( r, fac );//fac );//magnifier
                //
                //		x = r * cos( phi );
                //        y = r * sin( phi );
                
                float i = (x + 1.0 )*textureWidth*.5+textureRect.x;
                float j = (y + 1.0 )*textureHeight*.5+textureRect.y;
                i  = InBound(i, textureRect.x , textureRect.x +texWidth)?i:gUV.x;
                j = InBound(j, textureRect.y , textureRect.y+texHeight)?j:gUV.y;
                part =  texture2DRect( texUnit, vec2(i,j) ); //texture2DRect( whichTexture, vec2( texWidth/2.0-TexCoord.x*.8, TexCoord.y*.8+ texHeight/4.0) );
                
                int div = 67;
                float mul = float(div);
                part.r = float( int( part.r*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
                part.g = float( int( part.g*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
                part.b = float( int( part.b*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
                
                
            }
            else if( InBound(pCoord.x, left+ratio8*drawingWidth, left+ratio1*drawingWidth) && InBound( pCoord.y,top+ratio11*drawingHeight,top+ratio1*drawingHeight))
            {
                
                float x = 2.0 * (gUV.x*.98-textureRect.x*.98) / textureWidth - 1.0 ;
                float y = 2.0 * (gUV.y*.98-textureRect.y*.98) / textureHeight - 1.0 ;
                
                //		float r = sqrt(x*x + y*y);
                //        float phi = atan(y,x);//equivalent to atan2
                //
                //        float t = 3.1415/4.0;//mod( float( timer ), 30000.0 ) / 1000.0; //0 - 30 seconds
                //        float fac = abs( sin( t ) )*2.0 + .125;//+1.5;/// 2.0 + 1.5;
                //        r = pow( r, fac );//fac );//magnifier
                //
                //		x = r * cos( phi );
                //        y = r * sin( phi );
                
                float i = (x + 1.0 )*textureWidth*.5+textureRect.x;
                float j = (y + 1.0 )*textureHeight*.5+textureRect.y;
                i  = InBound(i , textureRect.x , textureRect.x+texWidth)?i:gUV.x;
                j = InBound(j, textureRect.y , textureRect.y+texHeight)?j:gUV.y;
                part =  texture2DRect( texUnit, vec2(i,j) ); //texture2DRect( whichTexture, vec2( texWidth/2.0-TexCoord.x*.8, TexCoord.y*.8+ texHeight/4.0) );
                
                int div = 40;
                float mul = float(div);
                part.r = float( int( part.r*360.0 ) / div )*mul / 360.0*1.1; //+ float(div)/360.0 ;
                part.g = float( int( part.g*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
                part.b = float( int( part.b*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
                
            }
            else if( InBound(pCoord.x, left+ratio4*drawingWidth, left+ratio10*drawingWidth) && InBound( pCoord.y,top+ratio6*drawingHeight, top+ratio11*drawingHeight))
            {
                
                float x = 2.0 * (gUV.x*1.1-textureRect.x*1.1) / textureWidth - 1.0 ;
                float y = 2.0 * (gUV.y*1.1-textureRect.y*1.1) / textureHeight - 1.0 ;
                
                //		float r = sqrt(x*x + y*y);
                //        float phi = atan(y,x);//equivalent to atan2
                //
                //        float t = 3.1415/4.0;//mod( float( timer ), 30000.0 ) / 1000.0; //0 - 30 seconds
                //        float fac = abs( sin( t ) )*2.0 + .125;//+1.5;/// 2.0 + 1.5;
                //        r = pow( r, fac );//fac );//magnifier
                //
                //		x = r * cos( phi );
                //        y = r * sin( phi );
                
                float i = (x + 1.0 )*textureWidth*.5+textureRect.x;
                float j = (y + 1.0 )*textureHeight*.5+textureRect.y;
                i  = InBound(i , textureRect.x, textureRect.x+texWidth)?i:gUV.x;
                j = InBound(j, textureRect.y , textureRect.y+texHeight)?j:gUV.y;
                part = texture2DRect( texUnit, vec2(i,j) ); //texture2DRect( whichTexture, vec2( texWidth/2.0-TexCoord.x*.8, TexCoord.y*.8+ texHeight/4.0) );
                
                int div = 50;
                float mul = float(div);
                part.r = float( int( part.r*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
                part.g = float( int( part.g*360.0 ) / div )*mul / 360.0*1.1; //+ float(div)/360.0 ;
                part.b = float( int( part.b*360.0 ) / div )*mul / 360.0*1.9; //+ float(div)/360.0 ;
                
            }
            else if( InBound(pCoord.x, left, left+ratio12*drawingWidth) && InBound( pCoord.y,top+ratio6*drawingHeight, top+ratio11*drawingHeight))
            {
                float x = textureHeight+textureRect.y -gUV.y;
                float y = textureWidth/2.0-(gUV.x-textureRect.x)+textureRect.x;
                
                x = InBound(x, textureRect.x, textureRect.x+texWidth)?x:gUV.x ;
                y = InBound(y, textureRect.y, textureRect.y+texHeight)?y:gUV.y;
                
                part =  texture2DRect( texUnit, vec2( x,y));
                
                int div = 60;
                float mul = float(div);
                part.r = float( int( part.r*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
                part.g = float( int( part.g*360.0 ) / div )*mul / 360.0*1.5; //+ float(div)/360.0 ;
                part.b = float( int( part.b*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
                
            }
            else if( InBound(pCoord.x, left, left+ratio13*drawingWidth) && InBound( pCoord.y,top+ratio11*drawingHeight, top+ratio1*drawingHeight))
            {
                float x = textureWidth/2.0-(gUV.x-textureRect.x)+textureRect.x;
                float y = textureHeight/2.0-(textureHeight+textureRect.y-gUV.y);
                x = InBound(x, textureRect.x, textureRect.x+texWidth)?x:gUV.x;
                y = InBound(y, textureRect.y, textureRect.y+texHeight)?y:gUV.y;
                
                part =  texture2DRect( texUnit, vec2( x , y) );
                
                int div = 90;
                float mul = float(div);
                part.r = float( int( part.r*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
                part.g = float( int( part.g*360.0 ) / div )*mul / 360.0*1.5; //+ float(div)/360.0 ;
                part.b = float( int( part.b*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;

            }
            else
            {
                float x = gUV.x*1.03;
                float y = gUV.y*1.03;
                x = InBound(x, textureRect.x, textureRect.x+texWidth)?x:gUV.x;
                y = InBound(y, textureRect.y, textureRect.y+texHeight)?y:gUV.y;
                part = texture2DRect( texUnit, vec2( x,y) );
                
                int div = 40;
                float mul = float(div);
                part.r = float( int( part.r*360.0 ) / div )*mul / 360.0*.7; //+ float(div)/360.0 ;
                part.g = float( int( part.g*360.0 ) / div )*mul / 360.0*1.8; //+ float(div)/360.0 ;
                part.b = float( int( part.b*360.0 ) / div )*mul / 360.0*1.3; //+ float(div)/360.0 ;
            }
        }
        gl_FragColor = modulateColor*part;
    }
}

vec3 RGBtoHSV( float r, float g, float b )
{
    float h, s, v;
    
    float theMin, theMax, delta;
    theMin = min( r, min(g, b) );
    theMax = max( r, max(g, b) );
    v = theMax;				// v
    delta = theMax - theMin;
    
    if( theMax != 0.0 )
        s = delta / theMax;		// s
    else {
        // r = g = b = 0		// s = 0, v is undefined
        s = 0.0;
        h = -1.0;
        return vec3(h, s, v);
    }
    
    if( r == theMax )
        h = ( g - b ) / delta;		// between yellow & magenta
    else if( g == theMax )
        h = 2.0 + ( b - r ) / delta;	// between cyan & yellow
    else
        h = 4.0 + ( r - g ) / delta;	// between magenta & cyan
    h *= 60.0;				// degrees
    if( h < 0.0 )
        h += 360.0;
    
    vec3 hsv = vec3( h, s, v );
    return hsv;
}

vec3 HSVtoRGB( float h, float s, float v )
{
    float r, g, b;
    
	float i;
	float f, p, q, t;
	if( s == 0.0 ) {
		// achromatic (grey)
		r = g = b = v;
		return vec3( r, g, b);
	}
	h /= 60.0;			// sector 0 to 5
	i = floor( h );
	f = h - float(i);			// factorial part of h
	p = v * ( 1.0 - s );
	q = v * ( 1.0 - s * f );
	t = v * ( 1.0 - s * ( 1.0 - f ) );
	if( i == 0.0 )
    {
        r = v;
        g = t;
        b = p;
	}
    else if( i == 1.0 )
    {
        r = q;
        g = v;
        b = p;
	}
    else if( i == 2.0 )
    {
        r = p;
        g = v;
        b = t;
    }
	else if( i == 3.0 )
    {
        r = p;
        g = q;
        b = v;
	}
	else if( i == 4.0 )
    {
        r = t;
        g = p;
        b = v;
    }
	else
    {
        r = v;
        g = p;
        b = q;
	}
    
    return vec3( r, g, b );
}